<p align="center">
  <a href="https://codingfleet.com/code-generator/python/?utm_source=github-repo&utm_medium=banner-2">
    <img src="images/codingfleet-banner-2.png" alt="CodingFleet Code Generator" width="350" height="350">
  </a><a href="https://codingfleet.com/code-converter/python/?utm_source=github-repo&utm_medium=banner-3">
    <img src="images/codingfleet-banner-3.png" alt="CodingFleet Code Converter" width="350" height="350">
  </a>
</p>



# Python Code Tutorials
This is a repository of all the tutorials of [The Python Code](https://www.thepythoncode.com) website.
## List of Tutorials
- ### [Ethical Hacking](https://www.thepythoncode.com/topic/ethical-hacking)
    -  ### [Scapy](https://www.thepythoncode.com/topic/scapy)
        - [Getting Started With Scapy: Python Network Manipulation Tool](https://www.thepythoncode.com/article/getting-started-with-scapy)
        - [Building an ARP Spoofer](https://www.thepythoncode.com/article/building-arp-spoofer-using-scapy). ([code](scapy/arp-spoofer))
        - [Detecting ARP Spoof attacks](https://www.thepythoncode.com/article/detecting-arp-spoof-attacks-using-scapy). ([code](scapy/arp-spoof-detector))
        - [How to Make a DHCP Listener using Scapy in Python](https://www.thepythoncode.com/article/dhcp-listener-using-scapy-in-python). ([code](scapy/dhcp_listener))
        - [Fake Access Point Generator](https://www.thepythoncode.com/article/create-fake-access-points-scapy). ([code](scapy/fake-access-point))
        - [Forcing a device to disconnect using scapy in Python](https://www.thepythoncode.com/article/force-a-device-to-disconnect-scapy). ([code](scapy/network-kicker))
        - [Simple Network Scanner](https://www.thepythoncode.com/article/building-network-scanner-using-scapy). ([code](scapy/network-scanner))
        - [Writing a DNS Spoofer](https://www.thepythoncode.com/article/make-dns-spoof-python). ([code](scapy/dns-spoof))
        - [How to Sniff HTTP Packets in the Network using Scapy in Python](https://www.thepythoncode.com/article/sniff-http-packets-scapy-python). ([code](scapy/http-sniffer))
        - [How to Build a WiFi Scanner in Python using Scapy](https://www.thepythoncode.com/article/building-wifi-scanner-in-python-scapy). ([code](scapy/wifi-scanner))
        - [How to Make a SYN Flooding Attack in Python](https://www.thepythoncode.com/article/syn-flooding-attack-using-scapy-in-python). ([code](scapy/syn-flood))
        - [How to Inject Code into HTTP Responses in the Network in Python](https://www.thepythoncode.com/article/injecting-code-to-html-in-a-network-scapy-python). ([code](scapy/http-code-injector/))
        - [How to Perform IP Address Spoofing in Python](https://thepythoncode.com/article/make-an-ip-spoofer-in-python-using-scapy). ([code](scapy/ip-spoofer))
        - [How to See Hidden Wi-Fi Networks in Python](https://thepythoncode.com/article/uncovering-hidden-ssids-with-scapy-in-python). ([code](scapy/uncover-hidden-wifis))
        - [Crafting Dummy Packets with Scapy Using Python](https://thepythoncode.com/article/crafting-packets-with-scapy-in-python). ([code](scapy/crafting-packets))
    - [Writing a Keylogger in Python from Scratch](https://www.thepythoncode.com/article/write-a-keylogger-python). ([code](ethical-hacking/keylogger))
    - [Making a Port Scanner using sockets in Python](https://www.thepythoncode.com/article/make-port-scanner-python). ([code](ethical-hacking/port_scanner))
    - [How to Create a Reverse Shell in Python](https://www.thepythoncode.com/article/create-reverse-shell-python). ([code](ethical-hacking/reverse_shell))
    - [How to Encrypt and Decrypt Files in Python](https://www.thepythoncode.com/article/encrypt-decrypt-files-symmetric-python). ([code](ethical-hacking/file-encryption))
    - [How to Make a Subdomain Scanner in Python](https://www.thepythoncode.com/article/make-subdomain-scanner-python). ([code](ethical-hacking/subdomain-scanner))
    - [How to Use Steganography to Hide Secret Data in Images in Python](https://www.thepythoncode.com/article/hide-secret-data-in-images-using-steganography-python). ([code](ethical-hacking/steganography))
    - [How to Brute-Force SSH Servers in Python](https://www.thepythoncode.com/article/brute-force-ssh-servers-using-paramiko-in-python). ([code](ethical-hacking/bruteforce-ssh))
    - [How to Build a XSS Vulnerability Scanner in Python](https://www.thepythoncode.com/article/make-a-xss-vulnerability-scanner-in-python). ([code](ethical-hacking/xss-vulnerability-scanner))
    - [How to Use Hash Algorithms in Python using hashlib](https://www.thepythoncode.com/article/hashing-functions-in-python-using-hashlib). ([code](ethical-hacking/hashing-functions/))
    - [How to Brute Force FTP Servers in Python](https://www.thepythoncode.com/article/brute-force-attack-ftp-servers-using-ftplib-in-python). ([code](ethical-hacking/ftp-cracker))
    - [How to Extract Image Metadata in Python](https://www.thepythoncode.com/article/extracting-image-metadata-in-python). ([code](ethical-hacking/image-metadata-extractor))
    - [How to Crack Zip File Passwords in Python](https://www.thepythoncode.com/article/crack-zip-file-password-in-python). ([code](ethical-hacking/zipfile-cracker))
    - [How to Crack PDF Files in Python](https://www.thepythoncode.com/article/crack-pdf-file-password-in-python). ([code](ethical-hacking/pdf-cracker))
    - [How to Build a SQL Injection Scanner in Python](https://www.thepythoncode.com/code/sql-injection-vulnerability-detector-in-python). ([code](ethical-hacking/sql-injection-detector))
    - [How to Extract Chrome Passwords in Python](https://www.thepythoncode.com/article/extract-chrome-passwords-python). ([code](ethical-hacking/chrome-password-extractor))
    - [How to Use Shodan API in Python](https://www.thepythoncode.com/article/using-shodan-api-in-python). ([code](ethical-hacking/shodan-api))
    - [How to Make an HTTP Proxy in Python](https://www.thepythoncode.com/article/writing-http-proxy-in-python-with-mitmproxy). ([code](ethical-hacking/http-mitm-proxy))
    - [How to Extract Chrome Cookies in Python](https://www.thepythoncode.com/article/extract-chrome-cookies-python). ([code](ethical-hacking/chrome-cookie-extractor))
    - [How to Extract Saved WiFi Passwords in Python](https://www.thepythoncode.com/article/extract-saved-wifi-passwords-in-python). ([code](ethical-hacking/get-wifi-passwords))
    - [How to Make a MAC Address Changer in Python](https://www.thepythoncode.com/article/make-a-mac-address-changer-in-python). ([code](ethical-hacking/mac-address-changer))
    - [How to Make a Password Generator in Python](https://www.thepythoncode.com/article/make-a-password-generator-in-python). ([code](ethical-hacking/password-generator))
    - [How to Make a Ransomware in Python](https://www.thepythoncode.com/article/make-a-ransomware-in-python). ([code](ethical-hacking/ransomware))
    - [How to Perform DNS Enumeration in Python](https://www.thepythoncode.com/article/dns-enumeration-with-python). ([code](ethical-hacking/dns-enumeration))
    - [How to Geolocate IP addresses in Python](https://www.thepythoncode.com/article/geolocate-ip-addresses-with-ipinfo-in-python). ([code](ethical-hacking/geolocating-ip-addresses))
    - [How to Crack Hashes in Python](https://thepythoncode.com/article/crack-hashes-in-python). ([code](ethical-hacking/hash-cracker))
    - [How to Make a Phone Number Tracker in Python](https://thepythoncode.com/article/phone-number-tracker-in-python). ([code](ethical-hacking/phone-number-tracker))
    - [How to Make a Login Password Guesser in Python](https://thepythoncode.com/article/make-a-login-password-guesser-in-python). ([code](ethical-hacking/login-password-guesser))
    - [How to Build a Password Manager in Python](https://thepythoncode.com/article/build-a-password-manager-in-python). ([code](ethical-hacking/password-manager))
    - [How to List Wi-Fi Networks in Python](https://thepythoncode.com/article/list-nearby-wifi-networks-with-python). ([code](ethical-hacking/listing-wifi-networks))
    - [How to Verify File Integrity in Python](https://thepythoncode.com/article/verify-downloaded-files-with-checksum-in-python). ([code](ethical-hacking/verify-file-integrity))
    - [How to Create a Zip File Locker in Python](https://thepythoncode.com/article/build-a-zip-file-locker-in-python). ([code](ethical-hacking/zip-file-locker))
    - [How to Implement the Caesar Cipher in Python](https://thepythoncode.com/article/implement-caesar-cipher-in-python). ([code](ethical-hacking/caesar-cipher))
    - [How to Crack the Caesar Cipher in Python](https://thepythoncode.com/article/how-to-crack-caesar-cipher-in-python). ([code](ethical-hacking/caesar-cipher))
    - [How to Lock PDFs in Python](https://thepythoncode.com/article/lock-pdfs-in-python). [(code)](ethical-hacking/pdf-locker)
    - [How to Create a Custom Wordlist in Python](https://thepythoncode.com/article/make-a-wordlist-generator-in-python). ([code](ethical-hacking/bruteforce-wordlist-generator))
    - [How to Implement the Affine Cipher in Python](https://thepythoncode.com/article/how-to-implement-affine-cipher-in-python). ([code](ethical-hacking/implement-affine-cipher))
    - [How to Crack the Affine Cipher in Python](https://thepythoncode.com/article/how-to-crack-the-affine-cipher-in-python). ([code](ethical-hacking/crack-affine-cipher))
    - [How to Implement the Vigenère Cipher in Python](https://thepythoncode.com/article/implementing-the-vigenere-cipher-in-python). ([code](ethical-hacking/implement-vigenere-cipher))
    - [How to Generate Fake User Data in Python](https://thepythoncode.com/article/generate-fake-user-data-in-python). ([code](ethical-hacking/fake-user-data-generator))
    - [Bluetooth Device Scanning in Python](https://thepythoncode.com/article/build-a-bluetooth-scanner-in-python). ([code](ethical-hacking/bluetooth-scanner))
    - [How to Create A Fork Bomb in Python](https://thepythoncode.com/article/make-a-fork-bomb-in-python). ([code](ethical-hacking/fork-bomb))
    - [How to Implement 2FA in Python](https://thepythoncode.com/article/implement-2fa-in-python). ([code](ethical-hacking/implement-2fa))
    - [How to Build a Username Search Tool in Python](https://thepythoncode.com/code/social-media-username-finder-in-python). ([code](ethical-hacking/username-finder))
    - [How to Find Past Wi-Fi Connections on Windows in Python](https://thepythoncode.com/article/find-past-wifi-connections-on-windows-in-python). ([code](ethical-hacking/find-past-wifi-connections-on-windows))
    - [How to Remove Metadata from PDFs in Python](https://thepythoncode.com/article/how-to-remove-metadata-from-pdfs-in-python). ([code](ethical-hacking/pdf-metadata-remover))
    - [How to Extract Metadata from Docx Files in Python](https://thepythoncode.com/article/docx-metadata-extractor-in-python). ([code](ethical-hacking/docx-metadata-extractor))
    - [How to Build Spyware in Python](https://thepythoncode.com/article/how-to-build-spyware-in-python). ([code](ethical-hacking/spyware))
    - [How to Exploit Command Injection Vulnerabilities in Python](https://thepythoncode.com/article/how-to-exploit-command-injection-vulnerabilities-in-python). ([code](ethical-hacking/exploit-command-injection))
    - [How to Make Malware Persistent in Python](https://thepythoncode.com/article/how-to-create-malware-persistent-in-python). ([code](ethical-hacking/persistent-malware))
    - [How to Remove Persistent Malware in Python](https://thepythoncode.com/article/removingg-persistent-malware-in-python). ([code](ethical-hacking/remove-persistent-malware))
    - [How to Check Password Strength with Python](https://thepythoncode.com/article/test-password-strength-with-python). ([code](ethical-hacking/checking-password-strength))
    - [How to Perform Reverse DNS Lookups Using Python](https://thepythoncode.com/article/reverse-dns-lookup-with-python). ([code](ethical-hacking/reverse-dns-lookup))
    - [How to Make a Clickjacking Vulnerability Scanner in Python](https://thepythoncode.com/article/make-a-clickjacking-vulnerability-scanner-with-python). ([code](ethical-hacking/clickjacking-scanner))
    - [How to Build a Custom NetCat with Python](https://thepythoncode.com/article/create-a-custom-netcat-in-python). ([code](ethical-hacking/custom-netcat/))

- ### [Machine Learning](https://www.thepythoncode.com/topic/machine-learning)
    - ### [Natural Language Processing](https://www.thepythoncode.com/topic/nlp)
        - [How to Build a Spam Classifier using Keras in Python](https://www.thepythoncode.com/article/build-spam-classifier-keras-python). ([code](machine-learning/nlp/spam-classifier))
        - [How to Build a Text Generator using TensorFlow and Keras in Python](https://www.thepythoncode.com/article/text-generation-keras-python). ([code](machine-learning/nlp/text-generator))
        - [How to Perform Text Classification in Python using Tensorflow 2 and Keras](https://www.thepythoncode.com/article/text-classification-using-tensorflow-2-and-keras-in-python). ([code](machine-learning/nlp/text-classification))
        - [Sentiment Analysis using Vader in Python](https://www.thepythoncode.com/article/vaderSentiment-tool-to-extract-sentimental-values-in-texts-using-python). ([code](machine-learning/nlp/sentiment-analysis-vader))
        - [How to Perform Text Summarization using Transformers in Python](https://www.thepythoncode.com/article/text-summarization-using-huggingface-transformers-python). ([code](machine-learning/nlp/text-summarization))
        - [How to Fine Tune BERT for Text Classification using Transformers in Python](https://www.thepythoncode.com/article/finetuning-bert-using-huggingface-transformers-python). ([code](machine-learning/nlp/bert-text-classification))
        - [Conversational AI Chatbot with Transformers in Python](https://www.thepythoncode.com/article/conversational-ai-chatbot-with-huggingface-transformers-in-python). ([code](machine-learning/nlp/chatbot-transformers))
        - [How to Train BERT from Scratch using Transformers in Python](https://www.thepythoncode.com/article/pretraining-bert-huggingface-transformers-in-python). ([code](machine-learning/nlp/pretraining-bert))
        - [How to Perform Machine Translation using Transformers in Python](https://www.thepythoncode.com/article/machine-translation-using-huggingface-transformers-in-python). ([code](machine-learning/nlp/machine-translation))
        - [Speech Recognition using Transformers in Python](https://www.thepythoncode.com/article/speech-recognition-using-huggingface-transformers-in-python). ([code](machine-learning/nlp/speech-recognition-transformers))
        - [Text Generation with Transformers in Python](https://www.thepythoncode.com/article/text-generation-with-transformers-in-python). ([code](machine-learning/nlp/text-generation-transformers))
        - [How to Paraphrase Text using Transformers in Python](https://www.thepythoncode.com/article/paraphrase-text-using-transformers-in-python). ([code](machine-learning/nlp/text-paraphrasing))
        - [Fake News Detection using Transformers in Python](https://www.thepythoncode.com/article/fake-news-classification-in-python). ([code](machine-learning/nlp/fake-news-classification))
        - [Named Entity Recognition using Transformers and Spacy in Python](https://www.thepythoncode.com/article/named-entity-recognition-using-transformers-and-spacy). ([code](machine-learning/nlp/named-entity-recognition))
        - [Tokenization, Stemming, and Lemmatization in Python](https://www.thepythoncode.com/article/tokenization-stemming-and-lemmatization-in-python). ([code](machine-learning/nlp/tokenization-stemming-lemmatization))
        - [How to Fine Tune BERT for Semantic Textual Similarity using Transformers in Python](https://www.thepythoncode.com/article/finetune-bert-for-semantic-textual-similarity-in-python). ([code](machine-learning/nlp/semantic-textual-similarity))
        - [How to Calculate the BLEU Score in Python](https://www.thepythoncode.com/article/bleu-score-in-python). ([code](machine-learning/nlp/bleu-score))
        - [Word Error Rate in Python](https://www.thepythoncode.com/article/calculate-word-error-rate-in-python). ([code](machine-learning/nlp/wer-score))
        - [How to Calculate ROUGE Score in Python](https://www.thepythoncode.com/article/calculate-rouge-score-in-python). ([code](machine-learning/nlp/rouge-score))
        - [Visual Question Answering with Transformers](https://www.thepythoncode.com/article/visual-question-answering-with-transformers-in-python). ([code](machine-learning/visual-question-answering))
    - ### [Computer Vision](https://www.thepythoncode.com/topic/computer-vision)
        - [How to Detect Human Faces in Python using OpenCV](https://www.thepythoncode.com/article/detect-faces-opencv-python). ([code](machine-learning/face_detection))
        - [How to Make an Image Classifier in Python using TensorFlow and Keras](https://www.thepythoncode.com/article/image-classification-keras-python). ([code](machine-learning/image-classifier))
        - [How to Use Transfer Learning for Image Classification using Keras in Python](https://www.thepythoncode.com/article/use-transfer-learning-for-image-flower-classification-keras-python). ([code](machine-learning/image-classifier-using-transfer-learning))
        - [How to Perform Edge Detection in Python using OpenCV](https://www.thepythoncode.com/article/canny-edge-detection-opencv-python). ([code](machine-learning/edge-detection))
        - [How to Detect Shapes in Images in Python](https://www.thepythoncode.com/article/detect-shapes-hough-transform-opencv-python). ([code](machine-learning/shape-detection))
        - [How to Detect Contours in Images using OpenCV in Python](https://www.thepythoncode.com/article/contour-detection-opencv-python). ([code](machine-learning/contour-detection))
        - [How to Recognize Optical Characters in Images in Python](https://www.thepythoncode.com/article/optical-character-recognition-pytesseract-python). ([code](machine-learning/optical-character-recognition))
        - [How to Use K-Means Clustering for Image Segmentation using OpenCV in Python](https://www.thepythoncode.com/article/kmeans-for-image-segmentation-opencv-python). ([code](machine-learning/kmeans-image-segmentation))
        - [How to Perform YOLO Object Detection using OpenCV and PyTorch in Python](https://www.thepythoncode.com/article/yolo-object-detection-with-opencv-and-pytorch-in-python). ([code](machine-learning/object-detection))
        - [How to Blur Faces in Images using OpenCV in Python](https://www.thepythoncode.com/article/blur-faces-in-images-using-opencv-in-python). ([code](machine-learning/blur-faces))
        - [Skin Cancer Detection using TensorFlow in Python](https://www.thepythoncode.com/article/skin-cancer-detection-using-tensorflow-in-python). ([code](machine-learning/skin-cancer-detection))
        - [How to Perform Malaria Cells Classification using TensorFlow 2 and Keras in Python](https://www.thepythoncode.com/article/malaria-cells-classification). ([code](machine-learning/malaria-classification))
        - [Image Transformations using OpenCV in Python](https://www.thepythoncode.com/article/image-transformations-using-opencv-in-python). ([code](machine-learning/image-transformation))
        - [How to Apply HOG Feature Extraction in Python](https://www.thepythoncode.com/article/hog-feature-extraction-in-python). ([code](machine-learning/hog-feature-extraction))
        - [SIFT Feature Extraction using OpenCV in Python](https://www.thepythoncode.com/article/sift-feature-extraction-using-opencv-in-python). ([code](machine-learning/sift))
        - [Age Prediction using OpenCV in Python](https://www.thepythoncode.com/article/predict-age-using-opencv). ([code](machine-learning/face-age-prediction))
        - [Gender Detection using OpenCV in Python](https://www.thepythoncode.com/article/gender-detection-using-opencv-in-python). ([code](machine-learning/face-gender-detection))
        - [Age and Gender Detection using OpenCV in Python](https://www.thepythoncode.com/article/gender-and-age-detection-using-opencv-python). ([code](machine-learning/age-and-gender-detection))
        - [Satellite Image Classification using TensorFlow in Python](https://www.thepythoncode.com/article/satellite-image-classification-using-tensorflow-python). ([code](machine-learning/satellite-image-classification))
        - [How to Perform Image Segmentation using Transformers in Python](https://www.thepythoncode.com/article/image-segmentation-using-huggingface-transformers-python). ([code](machine-learning/image-segmentation-transformers))
        - [How to Fine Tune ViT for Image Classification using Huggingface Transformers in Python](https://www.thepythoncode.com/article/finetune-vit-for-image-classification-using-transformers-in-python). ([code](machine-learning/finetuning-vit-image-classification))
        - [How to Generate Images from Text using Stable Diffusion in Python](https://www.thepythoncode.com/article/generate-images-from-text-stable-diffusion-python). ([code](machine-learning/stable-diffusion-models))
        - [How to Perform Image to Image Generation with Stable Diffusion in Python](https://www.thepythoncode.com/article/generate-images-using-depth-to-image-huggingface-python). ([code](machine-learning/depth2image-stable-diffusion))
        - [Real-time Object Tracking with OpenCV and YOLOv8 in Python](https://www.thepythoncode.com/article/real-time-object-tracking-with-yolov8-opencv). ([code](https://github.com/python-dontrepeatyourself/Real-Time-Object-Tracking-with-DeepSORT-and-YOLOv8))
        - [How to Control the Generated Images by diffusion models via ControlNet in Python](https://www.thepythoncode.com/article/control-generated-images-with-controlnet-with-huggingface). ([code](machine-learning/control-image-generation-with-controlnet))
        - [How to Edit Images using InstructPix2Pix in Python](https://www.thepythoncode.com/article/edit-images-using-instruct-pix2pix-with-huggingface). ([code](machine-learning/edit-images-instruct-pix2pix))
        - [How to Upscale Images using Stable Diffusion in Python](https://www.thepythoncode.com/article/upscale-images-using-stable-diffusion-x4-upscaler-huggingface). ([code](machine-learning/stable-diffusion-upscaler))
        - [Real-Time Vehicle Detection, Tracking and Counting in Python](https://thepythoncode.com/article/real-time-vehicle-tracking-and-counting-with-yolov8-opencv). ([code](https://github.com/python-dontrepeatyourself/Real-Time-Vehicle-Detection-Tracking-and-Counting-in-Python/))
        - [How to Cartoonify Images in Python](https://thepythoncode.com/article/make-a-cartoonifier-with-opencv-in-python). ([code](machine-learning/cartoonify-images))
        - [How to Make a Facial Recognition System in Python](https://thepythoncode.com/article/create-a-facial-recognition-system-in-python). ([code](machine-learning/facial-recognition-system))
        - [Non-Maximum Suppression with OpenCV and Python](https://thepythoncode.com/article/non-maximum-suppression-using-opencv-in-python). ([code](https://github.com/Rouizi/Non-Maximum-Suppression-with-OpenCV-and-Python))
    - [Building a Speech Emotion Recognizer using Scikit-learn](https://www.thepythoncode.com/article/building-a-speech-emotion-recognizer-using-sklearn). ([code](machine-learning/speech-emotion-recognition))
    - [How to Convert Speech to Text in Python](https://www.thepythoncode.com/article/using-speech-recognition-to-convert-speech-to-text-python). ([code](machine-learning/speech-recognition))
    - [Top 8 Python Libraries For Data Scientists and Machine Learning Engineers](https://www.thepythoncode.com/article/top-python-libraries-for-data-scientists).
    - [How to Predict Stock Prices in Python using TensorFlow 2 and Keras](https://www.thepythoncode.com/article/stock-price-prediction-in-python-using-tensorflow-2-and-keras). ([code](machine-learning/stock-prediction))
    - [How to Convert Text to Speech in Python](https://www.thepythoncode.com/article/convert-text-to-speech-in-python). ([code](machine-learning/text-to-speech))
    - [How to Perform Voice Gender Recognition using TensorFlow in Python](https://www.thepythoncode.com/article/gender-recognition-by-voice-using-tensorflow-in-python). ([code](https://github.com/x4nth055/gender-recognition-by-voice))
    - [Introduction to Finance and Technical Indicators with Python](https://www.thepythoncode.com/article/introduction-to-finance-and-technical-indicators-with-python). ([code](machine-learning/technical-indicators))
    - [Algorithmic Trading with FXCM Broker in Python](https://www.thepythoncode.com/article/trading-with-fxcm-broker-using-fxcmpy-library-in-python). ([code](machine-learning/trading-with-fxcm))
    - [How to Create Plots With Plotly In Python](https://www.thepythoncode.com/article/creating-dynamic-plots-with-plotly-visualization-tool-in-python). ([code](machine-learning/plotly-visualization))
    - [Feature Selection using Scikit-Learn in Python](https://www.thepythoncode.com/article/feature-selection-and-feature-engineering-using-python). ([code](machine-learning/feature-selection))
    - [Imbalance Learning With Imblearn and Smote Variants Libraries in Python](https://www.thepythoncode.com/article/handling-imbalance-data-imblearn-smote-variants-python). ([code](machine-learning/imbalance-learning))
    - [Credit Card Fraud Detection in Python](https://www.thepythoncode.com/article/credit-card-fraud-detection-using-sklearn-in-python#near-miss). ([code](machine-learning/credit-card-fraud-detection))
    - [Customer Churn Prediction in Python](https://www.thepythoncode.com/article/customer-churn-detection-using-sklearn-in-python). ([code](machine-learning/customer-churn-detection))
    - [Recommender Systems using Association Rules Mining in Python](https://www.thepythoncode.com/article/build-a-recommender-system-with-association-rule-mining-in-python). ([code](machine-learning/recommender-system-using-association-rules))
    - [Handling Imbalanced Datasets: A Case Study with Customer Churn](https://www.thepythoncode.com/article/handling-imbalanced-datasets-sklearn-in-python). ([code](machine-learning/handling-inbalance-churn-data))
    - [Logistic Regression using PyTorch in Python](https://www.thepythoncode.com/article/logistic-regression-using-pytorch). ([code](machine-learning/logistic-regression-in-pytorch))
    - [Dropout Regularization using PyTorch in Python](https://www.thepythoncode.com/article/dropout-regularization-in-pytorch). ([code](machine-learning/dropout-in-pytorch))
    - [K-Fold Cross Validation using Scikit-Learn in Python](https://www.thepythoncode.com/article/kfold-cross-validation-using-sklearn-in-python). ([code](machine-learning/k-fold-cross-validation-sklearn))
    - [Dimensionality Reduction: Feature Extraction using Scikit-learn in Python](https://www.thepythoncode.com/article/dimensionality-reduction-using-feature-extraction-sklearn). ([code](machine-learning/dimensionality-reduction-feature-extraction))
    - [Dimensionality Reduction: Using Feature Selection in Python](https://www.thepythoncode.com/article/dimensionality-reduction-feature-selection). ([code](machine-learning/dimensionality-reduction-feature-selection))
    - [A Guide to Explainable AI Using Python](https://www.thepythoncode.com/article/explainable-ai-model-python). ([code](machine-learning/explainable-ai))
    - [Autoencoders for Dimensionality Reduction using TensorFlow in Python](https://www.thepythoncode.com/article/feature-extraction-dimensionality-reduction-autoencoders-python-keras). ([code](machine-learning/feature-extraction-autoencoders))
    - [Exploring the Different Types of Clustering Algorithms in Machine Learning with Python](https://www.thepythoncode.com/article/clustering-algorithms-in-machine-learning-with-python). ([code](machine-learning/clustering-algorithms))
    - [Image Captioning using PyTorch and Transformers](https://www.thepythoncode.com/article/image-captioning-with-pytorch-and-transformers-in-python). ([code](machine-learning/image-captioning))
    - [Speech Recognition in Python](https://www.thepythoncode.com/article/speech-recognition-in-python). ([code](machine-learning/asr))

- ### [General Python Topics](https://www.thepythoncode.com/topic/general-python-topics)
    - [How to Make Facebook Messenger bot in Python](https://www.thepythoncode.com/article/make-bot-fbchat-python). ([code](general/messenger-bot))
    - [How to Get Hardware and System Information in Python](https://www.thepythoncode.com/article/get-hardware-system-information-python). ([code](general/sys-info))
    - [How to Control your Mouse in Python](https://www.thepythoncode.com/article/control-mouse-python). ([code](general/mouse-controller))
    - [How to Control your Keyboard in Python](https://www.thepythoncode.com/article/control-keyboard-python). ([code](general/keyboard-controller))
    - [How to Make a Process Monitor in Python](https://www.thepythoncode.com/article/make-process-monitor-python). ([code](general/process-monitor))
    - [How to Download Files in Python](https://www.thepythoncode.com/article/download-files-python). ([code](general/file-downloader))
    - [How to Execute BASH Commands in a Remote Machine in Python](https://www.thepythoncode.com/article/executing-bash-commands-remotely-in-python). ([code](general/execute-ssh-commands))
    - [How to Convert Python Files into Executables](https://www.thepythoncode.com/article/building-python-files-into-stand-alone-executables-using-pyinstaller)
    - [How to Get the Size of Directories in Python](https://www.thepythoncode.com/article/get-directory-size-in-bytes-using-python). ([code](general/calculate-directory-size))
    - [How to Get Geographic Locations in Python](https://www.thepythoncode.com/article/get-geolocation-in-python). ([code](general/geolocation))
    - [How to Assembly, Disassembly and Emulate Machine Code using Python](https://www.thepythoncode.com/article/arm-x86-64-assembly-disassembly-and-emulation-in-python). ([code](general/assembly-code))
    - [How to Change Text Color in Python](https://www.thepythoncode.com/article/change-text-color-in-python). ([code](general/printing-in-colors))
    - [How to Create a Watchdog in Python](https://www.thepythoncode.com/article/create-a-watchdog-in-python). ([code](general/directory-watcher))
    - [How to Convert Pandas Dataframes to HTML Tables in Python](https://www.thepythoncode.com/article/convert-pandas-dataframe-to-html-table-python). ([code](general/dataframe-to-html))
    - [How to Make a Simple Math Quiz Game in Python](https://www.thepythoncode.com/article/make-a-simple-math-quiz-game-in-python). ([code](general/simple-math-game))
    - [How to Make a Network Usage Monitor in Python](https://www.thepythoncode.com/article/make-a-network-usage-monitor-in-python). ([code](general/network-usage))
    - [How to Replace Text in Docx Files in Python](https://www.thepythoncode.com/article/replace-text-in-docx-files-using-python). ([code](general/docx-file-replacer))
    - [Zipf's Word Frequency Plot with Python](https://www.thepythoncode.com/article/plot-zipfs-law-using-matplotlib-python). ([code](general/zipf-curve))
    - [How to Plot Weather Temperature in Python](https://www.thepythoncode.com/article/interactive-weather-plot-with-matplotlib-and-requests). ([code](general/interactive-weather-plot/))
    - [How to Generate SVG Country Maps in Python](https://www.thepythoncode.com/article/generate-svg-country-maps-python). ([code](general/generate-svg-country-map))
    - [How to Query the Ethereum Blockchain with Python](https://www.thepythoncode.com/article/query-ethereum-blockchain-with-python). ([code](general/query-ethereum))
    - [Data Cleaning with Pandas in Python](https://www.thepythoncode.com/article/data-cleaning-using-pandas-in-python). ([code](general/data-cleaning-pandas))
    - [How to Minify CSS with Python](https://www.thepythoncode.com/article/minimize-css-files-in-python). ([code](general/minify-css))
    - [Build a real MCP client and server in Python with FastMCP (Todo Manager example)](https://www.thepythoncode.com/article/fastmcp-mcp-client-server-todo-manager). ([code](general/fastmcp-mcp-client-server-todo-manager))

    
    
- ### [Web Scraping](https://www.thepythoncode.com/topic/web-scraping)
    - [How to Access Wikipedia in Python](https://www.thepythoncode.com/article/access-wikipedia-python). ([code](web-scraping/wikipedia-extractor))
    - [How to Extract YouTube Data in Python](https://www.thepythoncode.com/article/get-youtube-data-python). ([code](web-scraping/youtube-extractor))
    - [How to Extract Weather Data from Google in Python](https://www.thepythoncode.com/article/extract-weather-data-python). ([code](web-scraping/weather-extractor))
    - [How to Download All Images from a Web Page in Python](https://www.thepythoncode.com/article/download-web-page-images-python). ([code](web-scraping/download-images))
    - [How to Extract All Website Links in Python](https://www.thepythoncode.com/article/extract-all-website-links-python). ([code](web-scraping/link-extractor))
    - [How to Make an Email Extractor in Python](https://www.thepythoncode.com/article/extracting-email-addresses-from-web-pages-using-python). ([code](web-scraping/email-extractor))
    - [How to Convert HTML Tables into CSV Files in Python](https://www.thepythoncode.com/article/convert-html-tables-into-csv-files-in-python). ([code](web-scraping/html-table-extractor))
    - [How to Use Proxies to Anonymize your Browsing and Scraping using Python](https://www.thepythoncode.com/article/using-proxies-using-requests-in-python). ([code](web-scraping/using-proxies))
    - [How to Extract Script and CSS Files from Web Pages in Python](https://www.thepythoncode.com/article/extract-web-page-script-and-css-files-in-python). ([code](web-scraping/webpage-js-css-extractor))
    - [How to Extract and Submit Web Forms from a URL using Python](https://www.thepythoncode.com/article/extracting-and-submitting-web-page-forms-in-python). ([code](web-scraping/extract-and-fill-forms))
    - [How to Get Domain Name Information in Python](https://www.thepythoncode.com/article/extracting-domain-name-information-in-python). ([code](web-scraping/get-domain-info))
    - [How to Extract YouTube Comments in Python](https://www.thepythoncode.com/article/extract-youtube-comments-in-python). ([code](web-scraping/youtube-comments-extractor))
    - [Automated Browser Testing with Edge and Selenium in Python](https://www.thepythoncode.com/article/automated-browser-testing-with-edge-and-selenium-in-python). ([code](web-scraping/selenium-edge-browser))
    - [How to Automate Login using Selenium in Python](https://www.thepythoncode.com/article/automate-login-to-websites-using-selenium-in-python). ([code](web-scraping/automate-login))
    - [How to Make a Currency Converter in Python](https://www.thepythoncode.com/article/make-a-currency-converter-in-python). ([code](web-scraping/currency-converter))
    - [How to Extract Google Trends Data in Python](https://www.thepythoncode.com/article/extract-google-trends-data-in-python). ([code](web-scraping/extract-google-trends-data))
    - [How to Make a YouTube Video Downloader in Python](https://www.thepythoncode.com/article/make-a-youtube-video-downloader-in-python). ([code](web-scraping/youtube-video-downloader))
    - [How to Build a YouTube Audio Downloader in Python](https://www.thepythoncode.com/article/build-a-youtube-mp3-downloader-tkinter-python). ([code](web-scraping/youtube-mp3-downloader))
    - [YouTube Video Transcription Summarization with Python](https://thepythoncode.com/article/youtube-video-transcription-and-summarization-with-python). ([code](web-scraping/youtube-transcript-summarizer/))

- ### [Python Standard Library](https://www.thepythoncode.com/topic/python-standard-library)
    - [How to Transfer Files in the Network using Sockets in Python](https://www.thepythoncode.com/article/send-receive-files-using-sockets-python). ([code](general/transfer-files/))
    - [How to Compress and Decompress Files in Python](https://www.thepythoncode.com/article/compress-decompress-files-tarfile-python). ([code](general/compressing-files))
    - [How to Use Pickle for Object Serialization in Python](https://www.thepythoncode.com/article/object-serialization-saving-and-loading-objects-using-pickle-python). ([code](general/object-serialization))
    - [How to Manipulate IP Addresses in Python using ipaddress module](https://www.thepythoncode.com/article/manipulate-ip-addresses-using-ipaddress-module-in-python). ([code](general/ipaddress-module))
    - [How to Send Emails in Python using smtplib Module](https://www.thepythoncode.com/article/sending-emails-in-python-smtplib). ([code](general/email-sender))
    - [How to Handle Files in Python using OS Module](https://www.thepythoncode.com/article/file-handling-in-python-using-os-module). ([code](python-standard-library/handling-files))
    - [How to Generate Random Data in Python](https://www.thepythoncode.com/article/generate-random-data-in-python). ([code](python-standard-library/generating-random-data))
    - [How to Use Threads to Speed Up your IO Tasks in Python](https://www.thepythoncode.com/article/using-threads-in-python). ([code](python-standard-library/using-threads))
    - [How to List all Files and Directories in FTP Server using Python](https://www.thepythoncode.com/article/list-files-and-directories-in-ftp-server-in-python). ([code](python-standard-library/listing-files-in-ftp-server))
    - [How to Read Emails in Python](https://www.thepythoncode.com/article/reading-emails-in-python). ([code](python-standard-library/reading-email-messages))
    - [How to Download and Upload Files in FTP Server using Python](https://www.thepythoncode.com/article/download-and-upload-files-in-ftp-server-using-python). ([code](python-standard-library/download-and-upload-files-in-ftp))
    - [How to Work with JSON Files in Python](https://www.thepythoncode.com/article/working-with-json-files-in-python). ([code](python-standard-library/working-with-json))
    - [How to Use Regular Expressions in Python](https://www.thepythoncode.com/article/work-with-regular-expressions-in-python). ([code](python-standard-library/regular-expressions))
    - [Logging in Python](https://www.thepythoncode.com/article/logging-in-python). ([code](python-standard-library/logging))
    - [How to Make a Chat Application in Python](https://www.thepythoncode.com/article/make-a-chat-room-application-in-python). ([code](python-standard-library/chat-application))
    - [How to Delete Emails in Python](https://www.thepythoncode.com/article/deleting-emails-in-python). ([code](python-standard-library/deleting-emails))
    - [Daemon Threads in Python](https://www.thepythoncode.com/article/daemon-threads-in-python). ([code](python-standard-library/daemon-thread))
    - [How to Organize Files by Extension in Python](https://www.thepythoncode.com/article/organize-files-by-extension-with-python). ([code](python-standard-library/extension-separator))
    - [How to Split a String In Python](https://www.thepythoncode.com/article/split-a-string-in-python). ([code](python-standard-library/split-string))
    - [How to Print Variable Name and Value in Python](https://www.thepythoncode.com/article/print-variable-name-and-value-in-python). ([code](python-standard-library/print-variable-name-and-value))
    - [How to Make a Hangman Game in Python](https://www.thepythoncode.com/article/make-a-hangman-game-in-python). ([code](python-standard-library/hangman-game))
    - [How to Use the Argparse Module in Python](https://www.thepythoncode.com/article/how-to-use-argparse-in-python). ([code](python-standard-library/argparse))
    - [How to Make a Grep Clone in Python](https://thepythoncode.com/article/how-to-make-grep-clone-in-python). ([code](python-standard-library/grep-clone))
    - [How to Validate Credit Card Numbers in Python](https://thepythoncode.com/article/credit-card-validation-in-python). ([code](python-standard-library/credit-card-validation))
    - [How to Build a TCP Proxy with Python](https://thepythoncode.com/article/building-a-tcp-proxy-with-python). ([code](python-standard-library/tcp-proxy))

- ### [Using APIs](https://www.thepythoncode.com/topic/using-apis-in-python)
    - [How to Automate your VPS or Dedicated Server Management in Python](https://www.thepythoncode.com/article/automate-veesp-server-management-in-python). ([code](general/automating-server-management))
    - [How to Download Torrent Files in Python](https://www.thepythoncode.com/article/download-torrent-files-in-python). ([code](general/torrent-downloader))
    - [How to Use Google Custom Search Engine API in Python](https://www.thepythoncode.com/article/use-google-custom-search-engine-api-in-python). ([code](general/using-custom-search-engine-api))
    - [How to Use Github API in Python](https://www.thepythoncode.com/article/using-github-api-in-python). ([code](general/github-api))
    - [How to Use Google Drive API in Python](https://www.thepythoncode.com/article/using-google-drive--api-in-python). ([code](general/using-google-drive-api))
    - [How to Translate Text in Python](https://www.thepythoncode.com/article/translate-text-in-python). ([code](general/using-google-translate-api))
    - [How to Make a URL Shortener in Python](https://www.thepythoncode.com/article/make-url-shortener-in-python). ([code](general/url-shortener))
    - [How to Get Google Page Ranking in Python](https://www.thepythoncode.com/article/get-google-page-ranking-by-keyword-in-python). ([code](general/getting-google-page-ranking))
    - [How to Make a Telegram Bot in Python](https://www.thepythoncode.com/article/make-a-telegram-bot-in-python). ([code](general/telegram-bot))
    - [How to Use Gmail API in Python](https://www.thepythoncode.com/article/use-gmail-api-in-python). ([code](general/gmail-api))
    - [How to Use YouTube API in Python](https://www.thepythoncode.com/article/using-youtube-api-in-python). ([code](general/youtube-api))
    - [Webhooks in Python with Flask](https://www.thepythoncode.com/article/webhooks-in-python-with-flask). ([code](https://github.com/bassemmarji/Flask_Webhook))
    - [How to Make a Language Detector in Python](https://www.thepythoncode.com/article/language-detector-in-python). ([code](general/language-detector))
    - [How to Build a Twitter (X) Bot in Python](https://thepythoncode.com/article/make-a-twitter-bot-in-python). ([code](https://github.com/menard-codes/dog-fact-tweeter-bot))

- ### [Database](https://www.thepythoncode.com/topic/using-databases-in-python)
    - [How to Use MySQL Database in Python](https://www.thepythoncode.com/article/using-mysql-database-in-python). ([code](database/mysql-connector))
    - [How to Connect to a Remote MySQL Database in Python](https://www.thepythoncode.com/article/connect-to-a-remote-mysql-server-in-python). ([code](database/connect-to-remote-mysql-server))
    - [How to Use MongoDB Database in Python](https://www.thepythoncode.com/article/introduction-to-mongodb-in-python). ([code](database/mongodb-client))

- ### [Handling PDF Files](https://www.thepythoncode.com/topic/handling-pdf-files)
    - [How to Extract All PDF Links in Python](https://www.thepythoncode.com/article/extract-pdf-links-with-python). ([code](web-scraping/pdf-url-extractor))
    - [How to Extract PDF Tables in Python](https://www.thepythoncode.com/article/extract-pdf-tables-in-python-camelot). ([code](general/pdf-table-extractor))
    - [How to Extract Images from PDF in Python](https://www.thepythoncode.com/article/extract-pdf-images-in-python). ([code](web-scraping/pdf-image-extractor))
    - [How to Watermark PDF Files in Python](https://www.thepythoncode.com/article/watermark-in-pdf-using-python). ([code](general/add-watermark-pdf))
    - [Highlighting Text in PDF with Python](https://www.thepythoncode.com/article/redact-and-highlight-text-in-pdf-with-python). ([code](handling-pdf-files/highlight-redact-text))
    - [How to Extract Text from Images in PDF Files with Python](https://www.thepythoncode.com/article/extract-text-from-images-or-scanned-pdf-python). ([code](handling-pdf-files/pdf-ocr))
    - [How to Convert PDF to Docx in Python](https://www.thepythoncode.com/article/convert-pdf-files-to-docx-in-python). ([code](handling-pdf-files/convert-pdf-to-docx))
    - [How to Convert PDF to Images in Python](https://www.thepythoncode.com/article/convert-pdf-files-to-images-in-python). ([code](handling-pdf-files/convert-pdf-to-image))
    - [How to Compress PDF Files in Python](https://www.thepythoncode.com/article/compress-pdf-files-in-python). ([code](handling-pdf-files/pdf-compressor))
    - [How to Encrypt and Decrypt PDF Files in Python](https://www.thepythoncode.com/article/encrypt-pdf-files-in-python). ([code](handling-pdf-files/encrypt-pdf))
    - [How to Merge PDF Files in Python](https://www.thepythoncode.com/article/merge-pdf-files-in-python). ([code](handling-pdf-files/pdf-merger))
    - [How to Sign PDF Files in Python](https://www.thepythoncode.com/article/sign-pdf-files-in-python). ([code](handling-pdf-files/pdf-signer))
    - [How to Extract PDF Metadata in Python](https://www.thepythoncode.com/article/extract-pdf-metadata-in-python). ([code](handling-pdf-files/extract-pdf-metadata))
    - [How to Split PDF Files in Python](https://www.thepythoncode.com/article/split-pdf-files-in-python). ([code](handling-pdf-files/split-pdf))
    - [How to Extract Text from PDF in Python](https://www.thepythoncode.com/article/extract-text-from-pdf-in-python). ([code](handling-pdf-files/extract-text-from-pdf))
    - [How to Convert HTML to PDF in Python](https://www.thepythoncode.com/article/convert-html-to-pdf-in-python). ([code](handling-pdf-files/convert-html-to-pdf))
    - [How to Make a GUI PDF Viewer in Python](https://www.thepythoncode.com/article/make-pdf-viewer-with-tktinter-in-python). ([code](gui-programming/pdf-viewer))
    
- ### [Python for Multimedia](https://www.thepythoncode.com/topic/python-for-multimedia)
    - [How to Make a Screen Recorder in Python](https://www.thepythoncode.com/article/make-screen-recorder-python). ([code](general/screen-recorder))
    - [How to Generate and Read QR Code in Python](https://www.thepythoncode.com/article/generate-read-qr-code-python). ([code](general/generating-reading-qrcode))
    - [How to Play and Record Audio in Python](https://www.thepythoncode.com/article/play-and-record-audio-sound-in-python). ([code](general/recording-and-playing-audio))
    - [How to Make a Barcode Reader in Python](https://www.thepythoncode.com/article/making-a-barcode-scanner-in-python). ([code](general/barcode-reader))
    - [How to Extract Audio from Video in Python](https://www.thepythoncode.com/article/extract-audio-from-video-in-python). ([code](general/video-to-audio-converter))
    - [How to Combine a Static Image with Audio in Python](https://www.thepythoncode.com/article/add-static-image-to-audio-in-python). ([code](python-for-multimedia/add-photo-to-audio))
    - [How to Concatenate Video Files in Python](https://www.thepythoncode.com/article/concatenate-video-files-in-python). ([code](python-for-multimedia/combine-video))
    - [How to Concatenate Audio Files in Python](https://www.thepythoncode.com/article/concatenate-audio-files-in-python). ([code](python-for-multimedia/combine-audio))
    - [How to Extract Frames from Video in Python](https://www.thepythoncode.com/article/extract-frames-from-videos-in-python). ([code](python-for-multimedia/extract-frames-from-video))
    - [How to Reverse Videos in Python](https://www.thepythoncode.com/article/reverse-video-in-python). ([code](python-for-multimedia/reverse-video))
    - [How to Extract Video Metadata in Python](https://www.thepythoncode.com/article/extract-media-metadata-in-python). ([code](python-for-multimedia/extract-video-metadata))
    - [How to Record a Specific Window in Python](https://www.thepythoncode.com/article/record-a-specific-window-in-python). ([code](python-for-multimedia/record-specific-window))
    - [How to Add Audio to Video in Python](https://www.thepythoncode.com/article/add-audio-to-video-in-python). ([code](python-for-multimedia/add-audio-to-video))
    - [How to Compress Images in Python](https://www.thepythoncode.com/article/compress-images-in-python). ([code](python-for-multimedia/compress-image))
    - [How to Remove Metadata from an Image in Python](https://thepythoncode.com/article/how-to-clear-image-metadata-in-python). ([code](python-for-multimedia/remove-metadata-from-images))
    - [How to Create Videos from Images in Python](https://thepythoncode.com/article/create-a-video-from-images-opencv-python). ([code](python-for-multimedia/create-video-from-images))
    - [How to Recover Deleted Files with Python](https://thepythoncode.com/article/how-to-recover-deleted-file-with-python). ([code](python-for-multimedia/recover-deleted-files))

- ### [Web Programming](https://www.thepythoncode.com/topic/web-programming)
    - [Detecting Fraudulent Transactions in a Streaming Application using Kafka in Python](https://www.thepythoncode.com/article/detect-fraudulent-transactions-with-apache-kafka-in-python). ([code](general/detect-fraudulent-transactions))
    - [Asynchronous Tasks with Celery in Python](https://www.thepythoncode.com/article/async-tasks-with-celery-redis-and-flask-in-python). ([code](https://github.com/bassemmarji/flask_sync_async))
    - [How to Build a CRUD App with Flask and SQLAlchemy in Python](https://www.thepythoncode.com/article/building-crud-app-with-flask-and-sqlalchemy). ([code](web-programming/bookshop-crud-app-flask))
    - [How to Build an English Dictionary App with Django in Python](https://www.thepythoncode.com/article/build-dictionary-app-with-django-and-pydictionary-api-python). ([code](web-programming/djangodictionary))
    - [How to Build a CRUD Application using Django in Python](https://www.thepythoncode.com/article/build-bookstore-app-with-django-backend-python). ([code](web-programming/bookshop-crud-app-django))
    - [How to Build a Weather App using Django in Python](https://www.thepythoncode.com/article/weather-app-django-openweather-api-using-python). ([code](web-programming/django-weather-app))
    - [How to Build an Authentication System in Django](https://www.thepythoncode.com/article/authentication-system-in-django-python). ([code](web-programming/django-authentication))
    - [How to Make a Blog using Django in Python](https://www.thepythoncode.com/article/create-a-blog-using-django-in-python). ([code](https://github.com/chepkiruidorothy/simple-blog-site))
    - [How to Make a Todo App using Django in Python](https://www.thepythoncode.com/article/build-a-todo-app-with-django-in-python). ([code](https://github.com/chepkiruidorothy/todo-app-simple/tree/master))
    - [How to Build an Email Address Verifier App using Django in Python](https://www.thepythoncode.com/article/build-an-email-verifier-app-using-django-in-python). ([code](web-programming/webbased-emailverifier))
    - [How to Build a Web Assistant Using Django and OpenAI GPT-3.5 API in Python](https://www.thepythoncode.com/article/web-assistant-django-with-gpt3-api-python). ([code](web-programming/webassistant))
    - [How to Make an Accounting App with Django in Python](https://www.thepythoncode.com/article/make-an-accounting-app-with-django-in-python). ([code](web-programming/accounting-app))
    - [How to Build a News Site API with Django Rest Framework in Python](https://www.thepythoncode.com/article/a-news-site-api-with-django-python). ([code](web-programming/news_project))
    - [How to Create a RESTful API with Flask in Python](https://www.thepythoncode.com/article/create-a-restful-api-with-flask-in-python). ([code](web-programming/restful-api-flask))
    - [How to Build a GraphQL API in Python](https://www.thepythoncode.com/article/build-a-graphql-api-with-fastapi-strawberry-and-postgres-python). ([code](https://github.com/menard-codes/PythonGQLArticle))
    - [How to Build a Chat App using Flask in Python](https://thepythoncode.com/article/how-to-build-a-chat-app-in-python-using-flask-and-flasksocketio). ([code](https://github.com/menard-codes/FlaskChatApp))
    - [How to Build a Full-Stack Web App in Python using FastAPI and React.js](https://thepythoncode.com/article/fullstack-notes-app-with-fastapi-and-reactjs) ([Backend](https://github.com/menard-codes/NotesAppBackend-FastAPI-React), [Frontend](https://github.com/menard-codes/NotesAppFrontend-FastAPI-React))

- ### [GUI Programming](https://www.thepythoncode.com/topic/gui-programming)
    - [How to Make a Text Editor using Tkinter in Python](https://www.thepythoncode.com/article/text-editor-using-tkinter-python). ([code](gui-programming/text-editor))
    - [How to Make a Button using PyGame in Python](https://www.thepythoncode.com/article/make-a-button-using-pygame-in-python). ([code](gui-programming/button-in-pygame))
    - [How to Make a File Explorer using Tkinter in Python](https://www.thepythoncode.com/article/create-a-simple-file-explorer-using-tkinter-in-python). ([code](gui-programming/file-explorer))
    - [How to Make a Calculator with Tkinter in Python](https://www.thepythoncode.com/article/make-a-calculator-app-using-tkinter-in-python). ([code](gui-programming/calculator-app))
    - [How to Make a Typing Speed Tester with Tkinter in Python](https://www.thepythoncode.com/article/how-to-make-typing-speed-tester-in-python-using-tkinter). ([code](gui-programming/type-speed-tester))
    - [How to Make a Markdown Editor using Tkinter in Python](https://www.thepythoncode.com/article/markdown-editor-with-tkinter-in-python). ([code](gui-programming/markdown-editor))
    - [How to Build a GUI Currency Converter using Tkinter in Python](https://www.thepythoncode.com/article/currency-converter-gui-using-tkinter-python). ([code](gui-programming/currency-converter-gui/))
    - [How to Detect Gender by Name using Python](https://www.thepythoncode.com/article/gender-predictor-gui-app-tkinter-genderize-api-python). ([code](gui-programming/genderize-app))
    - [How to Build a Spreadsheet App with Tkinter in Python](https://www.thepythoncode.com/article/spreadsheet-app-using-tkinter-in-python). ([code](gui-programming/spreadsheet-app))
    - [How to Make a Rich Text Editor with Tkinter in Python](https://www.thepythoncode.com/article/create-rich-text-editor-with-tkinter-python). ([code](gui-programming/rich-text-editor))
    - [How to Make a Python Code Editor using Tkinter in Python](https://www.thepythoncode.com/article/python-code-editor-using-tkinter-python). ([code](gui-programming/python-code-editor/))
    - [How to Make an Age Calculator in Python](https://www.thepythoncode.com/article/age-calculator-using-tkinter-python). ([code](gui-programming/age-calculator))
    - [How to Create an Alarm Clock App using Tkinter in Python](https://www.thepythoncode.com/article/build-an-alarm-clock-app-using-tkinter-python). ([code](gui-programming/alarm-clock-app))
    - [How to Build a GUI Voice Recorder App in Python](https://www.thepythoncode.com/article/make-a-gui-voice-recorder-python). ([code](gui-programming/voice-recorder-app))
    - [How to Build a GUI QR Code Generator and Detector Using Python](https://www.thepythoncode.com/article/make-a-qr-code-generator-and-reader-tkinter-python). ([code](gui-programming/qrcode-generator-reader-gui))
    - [How to Build a GUI Dictionary App with Tkinter in Python](https://www.thepythoncode.com/article/make-a-gui-audio-dictionary-python). ([code](gui-programming/word-dictionary-with-audio))
    - [How to Make a Real-Time GUI Spelling Checker in Python](https://www.thepythoncode.com/article/make-a-realtime-spelling-checker-gui-python). ([code](gui-programming/realtime-spelling-checker))
    - [How to Build a GUI Language Translator App in Python](https://www.thepythoncode.com/article/build-a-gui-language-translator-tkinter-python). ([code](gui-programming/gui-language-translator))
    - [How to Make an Image Editor in Python](https://www.thepythoncode.com/article/make-an-image-editor-in-tkinter-python). ([code](gui-programming/image-editor))
    - [How to Build a CRUD App with PyQt5 and SQLite3 in Python](https://thepythoncode.com/article/build-a-crud-app-using-pyqt5-and-sqlite3-in-python). ([code](gui-programming/crud-app-pyqt5))
    
- ### [Game Development](https://www.thepythoncode.com/topic/game-development)
    - [How to Make a Button using PyGame in Python](https://www.thepythoncode.com/article/make-a-button-using-pygame-in-python). ([code](gui-programming/button-in-pygame))
    - [How to Make a Drawing Program in Python](https://www.thepythoncode.com/article/make-a-drawing-program-with-python). ([code](gui-programming/drawing-tool-in-pygame))
    - [How to Make a Planet Simulator with PyGame in Python](https://www.thepythoncode.com/article/make-a-planet-simulator-using-pygame-in-python). ([code](gui-programming/planet-simulator))
    - [How to Make a Chess Game with Pygame in Python](https://www.thepythoncode.com/article/make-a-chess-game-using-pygame-in-python). ([code](gui-programming/chess-game))
    - [How to Create a GUI Hangman Game using PyGame in Python](https://www.thepythoncode.com/article/hangman-gui-game-with-pygame-in-python). ([code](gui-programming/hangman-game-gui))
    - [How to Make a Hangman Game in Python](https://www.thepythoncode.com/article/make-a-hangman-game-in-python). ([code](python-standard-library/hangman-game))
    - [How to Make a Text Adventure Game in Python](https://www.thepythoncode.com/article/make-a-text-adventure-game-with-python). ([code](general/text-adventure-game))
    - [How to Make a Tetris Game using PyGame in Python](https://www.thepythoncode.com/article/create-a-tetris-game-with-pygame-in-python). ([code](gui-programming/tetris-game))
    - [How to Build a Tic Tac Toe Game in Python](https://www.thepythoncode.com/article/make-a-tic-tac-toe-game-pygame-in-python). ([code](gui-programming/tictactoe-game))
    - [How to Make a Checkers Game with Pygame in Python](https://www.thepythoncode.com/article/make-a-checkers-game-with-pygame-in-python). ([code](gui-programming/checkers-game))
    - [How to Make a Snake Game in Python](https://www.thepythoncode.com/article/make-a-snake-game-with-pygame-in-python). ([code](gui-programming/snake-game))
    - [How to Create a Slide Puzzle Game in Python](https://www.thepythoncode.com/article/slide-puzzle-game-in-python). ([code](gui-programming/slide-puzzle))
    - [How to Make a Maze Game in Python](https://www.thepythoncode.com/article/build-a-maze-game-in-python). ([code](gui-programming/maze-game))
    - [How to Create a Platformer Game in Python](https://www.thepythoncode.com/article/platformer-game-with-pygame-in-python). ([code](gui-programming/platformer-game))
    - [How to Make a Flappy Bird Game in Python](https://thepythoncode.com/article/make-a-flappy-bird-game-python). ([code](gui-programming/flappy-bird-game))
    - [How to Create a Pong Game in Python](https://thepythoncode.com/article/build-a-pong-game-in-python). ([code](gui-programming/pong-game))
    - [How to Create a Space Invaders Game in Python](https://thepythoncode.com/article/make-a-space-invader-game-in-python). ([code](gui-programming/space-invaders-game))
    - [How to Build a Sudoku Game with Python](https://thepythoncode.com/article/make-a-sudoku-game-in-python). ([code](gui-programming/sudoku-game))
    - [How to Make a Pacman Game with Python](https://thepythoncode.com/article/creating-pacman-game-with-python). ([code](gui-programming/pacman-game))
    - [How to Add Sound Effects to your Python Game](https://thepythoncode.com/article/add-sound-effects-to-python-game-with-pygame). ([code](gui-programming/adding-sound-effects-to-games))
    - [How to Build a Breakout Game with PyGame in Python](https://thepythoncode.com/article/breakout-game-pygame-in-python). ([code](https://github.com/Omotunde2005/Breakout_with_pygame))


For any feedback, please consider pulling requests.
