# -*- coding: utf-8 -*-
"""TextGeneration-Transformers-PythonCodeTutorial.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1OUgJ92vQeFFYatf5gwtGulhA-mFwS0Md
"""

# !pip install transformers

from transformers import pipeline

# download & load GPT-2 model
gpt2_generator = pipeline('text-generation', model='gpt2')

# generate 3 different sentences
# results are sampled from the top 50 candidates
sentences = gpt2_generator("To be honest, neural networks", do_sample=True, top_k=50, temperature=0.6, max_length=128, num_return_sequences=3)
for sentence in sentences:
  print(sentence["generated_text"])
  print("="*50)

# download & load GPT-J model! It's 22.5GB in size
gpt_j_generator = pipeline('text-generation', model='EleutherAI/gpt-j-6B')

# generate sentences with TOP-K sampling
sentences = gpt_j_generator("To be honest, robots will", do_sample=True, top_k=50, temperature=0.6, max_length=128, num_return_sequences=3)
for sentence in sentences:
  print(sentence["generated_text"])
  print("="*50)

# generate Python Code!
print(gpt_j_generator(
"""
import os
# make a list of all african countries
""",
    do_sample=True, top_k=10, temperature=0.05, max_length=256)[0]["generated_text"])

print(gpt_j_generator(
"""
import cv2

image = "image.png"

# load the image and flip it
""",
    do_sample=True, top_k=10, temperature=0.05, max_length=256)[0]["generated_text"])

# complete bash script!
print(gpt_j_generator(
"""
# get .py files in /opt directory
ls *.py /opt
# get public ip address
""", max_length=256, top_k=50, temperature=0.05, do_sample=True)[0]["generated_text"])

# generating bash script!
print(gpt_j_generator(
"""
# update the repository
sudo apt-get update
# install and start nginx
""", max_length=128, top_k=50, temperature=0.1, do_sample=True)[0]["generated_text"])

# Java code!
print(gpt_j_generator(
"""
public class Test {

public static void main(String[] args){
  // printing the first 20 fibonacci numbers
""", max_length=128, top_k=50, temperature=0.1, do_sample=True)[0]["generated_text"])

# Commented out IPython magic to ensure Python compatibility.
# LATEX!
print(gpt_j_generator(
r"""
# % list of Asian countries
\begin{enumerate}
""", max_length=128, top_k=15, temperature=0.1, do_sample=True)[0]["generated_text"])

