# -*- coding: utf-8 -*-
"""Extracting-GoogleTrends-Data_PythonCodeTutorial.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1lMX3VemgcfGpiGNlQJNPyivSXHAVYe6O
"""

# !pip install pytrends

from pytrends.request import TrendReq
import seaborn
# for styling
seaborn.set_style("darkgrid")

# initialize a new Google Trends Request Object
pt = TrendReq(hl="en-US", tz=360)

# set the keyword & timeframe
pt.build_payload(["Python", "Java"], timeframe="all")

# get the interest over time
iot = pt.interest_over_time()
iot

# plot it
iot.plot(figsize=(10, 6))

# get hourly historical interest
data = pt.get_historical_interest(
    ["data science"], 
    cat=396, 
    year_start=2022, month_start=1, day_start=1, hour_start=0,
    year_end=2022, month_end=2, day_end=10, hour_end=23,
)
data

# the keyword to extract data
kw = "python"
pt.build_payload([kw], timeframe="all")
# get the interest by country
ibr = pt.interest_by_region("COUNTRY", inc_low_vol=True, inc_geo_code=True)

# sort the countries by interest
ibr[kw].sort_values(ascending=False)

# get related topics of the keyword
rt = pt.related_topics()
rt[kw]["top"]

# get related queries to previous keyword
rq = pt.related_queries()
rq[kw]["top"]

# get suggested searches
pt.suggestions("python")

# another example of suggested searches
pt.suggestions("America")

# trending searches per region
ts = pt.trending_searches(pn="united_kingdom")
ts

# real-time trending searches
pt.realtime_trending_searches()